/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.aoe;

import com.google.common.collect.AbstractIterator;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.tools.definition.aoe.IAreaOfEffectIterator;
import slimeknights.tconstruct.library.tools.definition.aoe.IBoxExpansion;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.JsonUtils;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class BoxAOEIterator
implements IAreaOfEffectIterator {
    public static final Loader LOADER = new Loader();
    private final BoxSize base;
    private final BoxSize[] expansions;
    private final IBoxExpansion direction;

    public static Builder builder(int width, int height, int depth) {
        return new Builder(new BoxSize(width, height, depth));
    }

    public GenericLoaderRegistry.IGenericLoader<? extends IAreaOfEffectIterator> getLoader() {
        return LOADER;
    }

    private BoxSize sizeFor(int level) {
        if (level == 0 || this.expansions.length == 0) {
            return this.base;
        }
        int width = this.base.width;
        int height = this.base.height;
        int depth = this.base.depth;
        if (level >= this.expansions.length) {
            int cycles = level / this.expansions.length;
            for (BoxSize expansion : this.expansions) {
                width += expansion.width * cycles;
                height += expansion.height * cycles;
                depth += expansion.depth * cycles;
            }
        }
        int remainder = level % this.expansions.length;
        for (int i = 0; i < remainder; ++i) {
            BoxSize expansion = this.expansions[i];
            width += expansion.width;
            height += expansion.height;
            depth += expansion.depth;
        }
        return new BoxSize(width, height, depth);
    }

    @Override
    public Iterable<BlockPos> getBlocks(IToolStackView tool, ItemStack stack, Player player, BlockState state, Level world, BlockPos origin, Direction sideHit, IAreaOfEffectIterator.AOEMatchType matchType) {
        int expanded = tool.getModifierLevel(TinkerModifiers.expanded.getId());
        return BoxAOEIterator.calculate(tool, stack, world, player, origin, sideHit, this.sizeFor(expanded), this.direction, matchType);
    }

    public static Iterable<BlockPos> calculate(IToolStackView tool, ItemStack stack, Level world, Player player, BlockPos origin, Direction sideHit, BoxSize extraSize, IBoxExpansion expansionDirection, IAreaOfEffectIterator.AOEMatchType matchType) {
        if (extraSize.isZero()) {
            return Collections.emptyList();
        }
        IBoxExpansion.ExpansionDirections expansion = expansionDirection.getDirections(player, sideHit);
        Predicate<BlockPos> posPredicate = IAreaOfEffectIterator.defaultBlockPredicate(tool, stack, world, origin, matchType);
        return () -> new RectangleIterator(origin, expansion.width(), extraSize.width, expansion.height(), extraSize.height, expansion.traverseDown(), expansion.depth(), extraSize.depth, posPredicate);
    }

    protected BoxAOEIterator(BoxSize base, BoxSize[] expansions, IBoxExpansion direction) {
        this.base = base;
        this.expansions = expansions;
        this.direction = direction;
    }

    public static class Builder {
        private final BoxSize base;
        @Nonnull
        private IBoxExpansion direction = IBoxExpansion.SIDE_HIT;
        private final List<BoxSize> expansions = new ArrayList<BoxSize>();

        public Builder addExpansion(int width, int height, int depth) {
            this.expansions.add(new BoxSize(width, height, depth));
            return this;
        }

        public Builder addWidth(int width) {
            return this.addExpansion(width, 0, 0);
        }

        public Builder addHeight(int height) {
            return this.addExpansion(0, height, 0);
        }

        public Builder addDepth(int depth) {
            return this.addExpansion(0, 0, depth);
        }

        public BoxAOEIterator build() {
            return new BoxAOEIterator(this.base, this.expansions.toArray(new BoxSize[0]), this.direction);
        }

        public Builder(BoxSize base) {
            this.base = base;
        }

        public Builder direction(@Nonnull IBoxExpansion direction) {
            if (direction == null) {
                throw new NullPointerException("direction is marked non-null but is null");
            }
            this.direction = direction;
            return this;
        }
    }

    private record BoxSize(int width, int height, int depth) {
        public boolean isZero() {
            return this.width == 0 && this.height == 0 && this.depth == 0;
        }

        public JsonObject toJson() {
            JsonObject object = new JsonObject();
            if (this.width > 0) {
                object.addProperty("width", (Number)this.width);
            }
            if (this.height > 0) {
                object.addProperty("height", (Number)this.height);
            }
            if (this.depth > 0) {
                object.addProperty("depth", (Number)this.depth);
            }
            return object;
        }

        public void toNetwork(FriendlyByteBuf buf) {
            buf.m_130130_(this.width);
            buf.m_130130_(this.height);
            buf.m_130130_(this.depth);
        }

        public static BoxSize fromJson(JsonObject json) {
            return new BoxSize(JsonUtils.getIntMin(json, "width", 0), JsonUtils.getIntMin(json, "height", 0), JsonUtils.getIntMin(json, "depth", 0));
        }

        public static BoxSize fromNetwork(FriendlyByteBuf buffer) {
            return new BoxSize(buffer.m_130242_(), buffer.m_130242_(), buffer.m_130242_());
        }
    }

    private static class Loader
    implements GenericLoaderRegistry.IGenericLoader<BoxAOEIterator> {
        private Loader() {
        }

        public BoxAOEIterator deserialize(JsonObject json) {
            BoxSize base = BoxSize.fromJson(GsonHelper.m_13930_((JsonObject)json, (String)"bonus"));
            BoxSize[] expansions = json.has("expansions") ? JsonHelper.parseList((JsonObject)json, (String)"expansions", BoxSize::fromJson).toArray(new BoxSize[0]) : new BoxSize[]{};
            IBoxExpansion direction = (IBoxExpansion)IBoxExpansion.REGISTRY.deserialize(json, "expansion_direction");
            return new BoxAOEIterator(base, expansions, direction);
        }

        public BoxAOEIterator fromNetwork(FriendlyByteBuf buffer) {
            BoxSize base = BoxSize.fromNetwork(buffer);
            int count = buffer.m_130242_();
            BoxSize[] expansions = new BoxSize[count];
            for (int i = 0; i < count; ++i) {
                expansions[i] = BoxSize.fromNetwork(buffer);
            }
            IBoxExpansion direction = (IBoxExpansion)IBoxExpansion.REGISTRY.fromNetwork(buffer);
            return new BoxAOEIterator(base, expansions, direction);
        }

        public void serialize(BoxAOEIterator object, JsonObject json) {
            json.add("bonus", (JsonElement)object.base.toJson());
            if (object.expansions.length > 0) {
                JsonArray expansions = new JsonArray();
                for (BoxSize box : object.expansions) {
                    expansions.add((JsonElement)box.toJson());
                }
                json.add("expansions", (JsonElement)expansions);
                json.addProperty("expansion_direction", IBoxExpansion.REGISTRY.getKey((Object)object.direction).toString());
            }
        }

        public void toNetwork(BoxAOEIterator object, FriendlyByteBuf buffer) {
            object.base.toNetwork(buffer);
            buffer.m_130130_(object.expansions.length);
            for (BoxSize box : object.expansions) {
                box.toNetwork(buffer);
            }
            IBoxExpansion.REGISTRY.toNetwork((Object)object.direction, buffer);
        }
    }

    public static class RectangleIterator
    extends AbstractIterator<BlockPos> {
        private final Direction widthDir;
        private final Direction heightDir;
        private final Direction depthDir;
        private final int maxWidth;
        private final int maxHeight;
        private final int maxDepth;
        private int currentWidth = 0;
        private int currentHeight = 0;
        private int currentDepth = 0;
        protected final BlockPos origin;
        protected final BlockPos.MutableBlockPos mutablePos;
        protected final Predicate<BlockPos> posPredicate;
        protected int lastX;
        protected int lastY;
        protected int lastZ;

        public RectangleIterator(BlockPos origin, Direction widthDir, int extraWidth, Direction heightDir, int extraHeight, boolean traverseDown, Direction depthDir, int extraDepth, Predicate<BlockPos> posPredicate) {
            this.origin = origin;
            this.widthDir = widthDir;
            this.heightDir = heightDir;
            this.depthDir = depthDir;
            this.maxWidth = extraWidth * 2;
            this.maxHeight = traverseDown ? extraHeight * 2 : extraHeight;
            this.maxDepth = extraDepth;
            this.mutablePos = new BlockPos.MutableBlockPos(origin.m_123341_(), origin.m_123342_(), origin.m_123343_());
            this.posPredicate = posPredicate;
            if (extraWidth > 0) {
                --this.currentWidth;
            } else if (extraHeight > 0) {
                --this.currentHeight;
            }
            this.mutablePos.m_122175_(widthDir, -extraWidth + this.currentWidth);
            if (traverseDown) {
                this.mutablePos.m_122175_(heightDir, -extraHeight + this.currentHeight);
            } else if (this.currentHeight != 0) {
                this.mutablePos.m_122175_(heightDir, this.currentHeight);
            }
            this.lastX = this.mutablePos.m_123341_();
            this.lastY = this.mutablePos.m_123342_();
            this.lastZ = this.mutablePos.m_123343_();
        }

        protected boolean incrementPosition() {
            if (this.currentWidth == this.maxWidth) {
                if (this.currentHeight == this.maxHeight) {
                    if (this.currentDepth == this.maxDepth) {
                        return false;
                    }
                    ++this.currentDepth;
                    this.mutablePos.m_122173_(this.depthDir);
                    this.currentHeight = 0;
                    this.mutablePos.m_122175_(this.heightDir, -this.maxHeight);
                } else {
                    ++this.currentHeight;
                    this.mutablePos.m_122173_(this.heightDir);
                }
                this.currentWidth = 0;
                this.mutablePos.m_122175_(this.widthDir, -this.maxWidth);
            } else {
                ++this.currentWidth;
                this.mutablePos.m_122173_(this.widthDir);
            }
            return true;
        }

        protected BlockPos computeNext() {
            this.mutablePos.m_122178_(this.lastX, this.lastY, this.lastZ);
            while (this.incrementPosition()) {
                if (this.mutablePos.equals((Object)this.origin) || !this.posPredicate.test((BlockPos)this.mutablePos)) continue;
                this.lastX = this.mutablePos.m_123341_();
                this.lastY = this.mutablePos.m_123342_();
                this.lastZ = this.mutablePos.m_123343_();
                return this.mutablePos;
            }
            return (BlockPos)this.endOfData();
        }
    }
}

